#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)

static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {0.f,0.f,FOND_Z,  0,0,0,   0,255.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,0,FOND_Z,   0,0,0,   0,255.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond7 = {640.,480.,FOND_Z,   0,0,0,   0,255.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {0,480.,FOND_Z,   0,0,0,   0,255.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static Obj3d *pDrapeau, *pDrapeau2;
static float Matrix[256], Matrix2[256];

static float Sin256f[256], Cos256f[256];

void LInit_Drapeau()
{
	unsigned int Cpt1;

	//pDrapeau = GenerateFloor(20, 10, 800, 600, 256, 256);
	pDrapeau = GenerateFloor(10, 10, 800, 600, 256, 256);
	pDrapeau2 = CopyObj(pDrapeau);

	for(Cpt1=0;Cpt1<pDrapeau2->NbVertex;Cpt1++)
	{
		pDrapeau2->pVertexIn[Cpt1].tmuvtx[0].sow = 256.f - pDrapeau2->pVertexIn[Cpt1].tmuvtx[0].sow;
	}

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		Cos256f[Cpt1] = 128.f * (float)cos(Cpt1*PI2/256.f);
		Sin256f[Cpt1] = 128.f * (float)sin(Cpt1*PI2/256.f);
	}
	PrepareTextureFromArray(g_PicLogo2, 256, 256, &g_TextureLogo2);
	PrepareTextureFromArray(g_PicTunnelPov, 256, 256, &g_TextureTunnelPov);
	PrepareTextureFromArray(g_PicLikid, 256, 256, &g_TextureLikid);
	PrepareTextureFromArray(g_PicLogo, 256, 256, &g_TextureLogo);
}

void QInit_Drapeau()
{
	grSstControl(GR_CONTROL_ACTIVATE);
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureLogo);
	DownloadTexture(&g_TextureLogo2);
	DownloadTexture(&g_TextureLikid);
	DownloadTexture(&g_TextureTunnelPov);

}

void Effect_Drapeau()
{
	//float RotY = 0;
	int RotY;
	int Cpt1, Cpt2, Cpt3;
	int Img1;
	
	Img1 = g_demostate.TickInEffect/2;

	Cpt3=0;	

	for(Cpt1=0;Cpt1<11;Cpt1++)
	{
		//for(Cpt2=0;Cpt2<21;Cpt2++)
		for(Cpt2=0;Cpt2<11;Cpt2++)
		{
			pDrapeau2->pVertexIn[Cpt3].z = pDrapeau->pVertexIn[Cpt3].z = 
				//Sin256f[(Img1+Cpt1*36)&255] + Cos256f[(Img1+Cpt2*18)&255];
				Sin256f[(Img1+Cpt1*36)&255] + Cos256f[(Img1+Cpt2*36)&255];
			Cpt3++;
		}
	}

	grDepthMask(FXFALSE);
	grCullMode(GR_CULL_DISABLE);
	SelectTexture(g_TextureLikid);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);			
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
	grDepthMask(FXTRUE);
	
	//RotY += 0.012f;
	RotY = g_demostate.TickInEffect;

	BeIdentityMatrix(Matrix);
	grCullMode(GR_CULL_POSITIVE);
	RotateYMatrix(Matrix2, Matrix, RotY);
	TranslateMatrix(Matrix2, 0,0,1250);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(128);
	SelectTexture(g_TextureLogo);
	DrawWithMatrix(pDrapeau2, Matrix2, 0, 0, 0);

	grCullMode(GR_CULL_NEGATIVE);
	grConstantColorValue((128<<16));
	SelectTexture(g_TextureLogo2);
	DrawWithMatrix(pDrapeau, Matrix2, 0, 0, 0);

	grDepthBufferFunction(GR_CMP_ALWAYS);
	grDepthMask(FXFALSE);
	grCullMode(GR_CULL_DISABLE);
	grChromakeyMode(GR_CHROMAKEY_ENABLE);
	SelectTexture(g_TextureTunnelPov);
	grDrawTriangle(&Fond5, &Fond6, &Fond7);			
	grDrawTriangle(&Fond7, &Fond8, &Fond5);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grDepthMask(FXTRUE);
}

void ByeBye_Drapeau()
{
	FreeTexture(&g_TextureLogo);
	FreeTexture(&g_TextureLogo2);
	FreeTexture(&g_TextureLikid);
	FreeTexture(&g_TextureTunnelPov);
}